unit BigBucks_u;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, BigBucks_d, DBGrids;

type
  TfrmBigBucks = class(TForm)
    edtSender: TEdit;
    edtReceiver: TEdit;
    edtAmount: TEdit;
    btnMakePayment: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    grdBigBucks: TDBGrid;
    procedure btnMakePaymentClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmBigBucks: TfrmBigBucks;

implementation

{$R *.dfm}

procedure TfrmBigBucks.btnMakePaymentClick(Sender: TObject);
  var
    sSender, sReceiver: String;
    rAmount, rExisting: Real;
  begin
    sSender := edtSender.Text;
    sReceiver := edtReceiver.Text;
    rAmount := StrToFloat(edtAmount.Text);

    dbmBigBucks.tblBigBucks.First;
    while (not dbmBigBucks.tblBigBucks.Eof) and (rAmount > 0) do
      begin
        if (sSender = dbmBigBucks.tblBigBucks['receiver']) and
          (sReceiver = dbmBigBucks.tblBigBucks['sender']) then
          begin
            rExisting := dbmBigBucks.tblBigBucks['payment'];

            if rAmount >= rExisting then
              begin
                dbmBigBucks.tblBigBucks.Delete;
                rAmount := rAmount - rExisting
              end;

            if rAmount < rExisting then
              begin
                dbmBigBucks.tblBigBucks.Edit;
                dbmBigBucks.tblBigBucks['payment'] := rExisting - rAmount;
                dbmBigBucks.tblBigBucks['repayment_date'] := Now;
                dbmBigBucks.tblBigBucks.Post;
                rAmount := 0;
              end;
          end;
        dbmBigBucks.tblBigBucks.Next;
      end;

    if rAmount > 0 then
      begin
        dbmBigBucks.tblBigBucks.Append;
        dbmBigBucks.tblBigBucks['sender'] := sSender;
        dbmBigBucks.tblBigBucks['receiver'] := sReceiver;
        dbmBigBucks.tblBigBucks['payment'] := rAmount;
        dbmBigBucks.tblBigBucks['creation_date'] := Now;
        dbmBigBucks.tblBigBucks.Post;
      end;

  end;

end.
